/**
 * @customElement
 * @polymer
 */
class PlanarDie extends Polymer.Element {
  static get is() { return 'planar-die'; }
  
  static get properties() {
    return {
      chaoticAether: Boolean,
    };
  }
  
  constructor() {
    super();
    
    this.faceRotation = [
      "rotate3d(0, 0, 1, -90deg)",
      "rotate3d(1, 0, 0, 180deg)",
      "rotate3d(0, 1, 0, -90deg)",
      "rotate3d(0, 1, 0, 90deg)",
      "rotate3d(1, 0, 0, -90deg)",
      "rotate3d(1, 0, 0, 90deg)",
    ];
  }
  
  rollDie() {
    const faces = [...this.$.die.children];
    faces.forEach((face) => face.classList.remove('face-up'));
    
    this.$.die.style.left = `${Math.random() * (innerWidth - 100)}px`;
    this.$.die.style.right = `${Math.random() * (innerHeight - 100)}px`;
    this.$.die.style.transform = `rotate3d(1, 0, 0, ${Math.random() * 360}deg)
        rotate3d(0, 1, 0, ${Math.random() * 360}deg)
        rotate3d(0, 0, 1, ${Math.random() * 360}deg)`;
    
    setTimeout(() => {
      const randFace = Math.round(Math.random() * 5);
      this.$.die.style.transform = this.faceRotation[randFace];
      faces[randFace].classList.add('face-up');
      
      if (randFace === 0) {
        this.dispatchEvent(new CustomEvent('rolled-planeswalk', {
          bubbles: true,
          composed: true,
        }));
      } else {
        if ((!this.chaoticAether && randFace === 1) || this.chaoticAether) {
          this.dispatchEvent(new CustomEvent('rolled-chaos', {
            bubbles: true,
            composed: true,
          }));
        }
      }
    }, 900);
  }
}

window.customElements.define(PlanarDie.is, PlanarDie);