/**
 * Module dependencies
 */
var express = require('express'),
    logger = require('morgan'),
    stylus = require('stylus'),
    nib = require('nib'),
    mysql = require('mysql'),
    app = express(),
    router = express.Router(),
    conn;

function compile(str, path) {
	return stylus(str).set('filename', path).use(nib());
}

function exitHandler(options, err) {
	conn || conn.end();
	if(options.cleanup)
		console.log('clean');
	if (err)
		console.log(err.stack);
	if (options.exit)
		process.exit();
}

process.on('exit', exitHandler.bind(null, { cleanup: true }));

app.set('views', __dirname + '/views');
app.set('view engine', 'jade');
app.use(logger('dev'));
app.use(stylus.middleware({ src: __dirname + '/public', compile: compile }));
app.use(express.static(__dirname + '/public'));

router.use(function(req, res, next) {
    console.log('/' + req.method);
    next();
});

router.get(/*\/(index\.html)?*/'/', function(req, res) {
	var streets = {}, i;
	
	conn = mysql.createConnection({
		host: 'localhost',
		user: 'iot_admin',
		password: 'CamelCase89!',
		database: 'iot_lights'
	});

	conn.connect(function(err) { if (err) console.log(err); });
	conn.query('SELECT id, name FROM streets', function(err, rows) {
		if (err) throw err;
		
		for (i = 0; i < rows.length; i++) {
			streets[rows[i].id.toString()] = rows[i].name;
		}
    	res.render('index', {
        	title: 'Internet of Lights',
	        streets: streets
	    });
	});
});
router.get('/edit', function(req, res) {
	res.render('edit-schedule', {
		title: 'Internet of Lights &ndash; Edit Schedules'
	});
});

app.use('/', router);
/*app.use('*', function(req, res) {
    res.render('404');
});*/
app.listen(3000);
